package gov.va.med.mhv.sm.admin.jpa.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import gov.va.med.mhv.sm.admin.jpa.model.AbstractBaseEntity;

@Entity
@Table(name = "PATIENT_FACILITY")
@DynamicUpdate(value = false)
@SelectBeforeUpdate(value = true)
public class PatientFacility extends AbstractBaseEntity {

	private static final long serialVersionUID = 821003502127371746L;

	@Id
	@Column(name = "USER_FACILITY_ID", insertable = false, updatable = false)
	private Long id;

	@Column(name = "USER_ID", insertable = false, updatable = false)
	private String userId;

	@Column(name = "VISTA_DIV", insertable = false, updatable = false)
	private String stationNumber;
	

	public PatientFacility() {
	}

	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}


	public String getUserId() {
		return userId;
	}


	public void setUserId(String userId) {
		this.userId = userId;
	}


	public String getStationNumber() {
		return stationNumber;
	}


	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

}
